<?php

namespace NioModules\WdPaypal\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SaveUserAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'wdm-label' => 'nullable|string',
            'wdm-email' => 'required|email|regex:/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,9}$/ix',
            'wdm-currency' => 'required|string',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'wdm-email.*' => __('Enter a valid email address.'),
            'wdm-currency.*' => __('Please select your wallet.'),
        ];
    }
}
